//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T>
struct st_Data
{
    //+----------------+
    private:
    //+----------------+
        struct st_Reg
        {
            T       h_value;
            uint    k_value;
        }Values[];
    //+----------------+
        string ConvertToString(T arg)
        {
            if ((typename(T) == "double") || (typename(T) == "float")) return DoubleToString(arg, 2);
            if (typename(T) == "string") return arg;

            return IntegerToString(arg);
        }
    //+----------------+
    public:
    //+----------------+
        bool Set(const uint &arg1[], const T &arg2[])
        {
            if (arg1.Size() != arg2.Size())
                return false;
            
            ArrayResize(Values, arg1.Size());
            for (uint c = 0; c < arg1.Size(); c++)
            {
                Values[c].k_value = arg1[c];
                Values[c].h_value = arg2[c];
            }

            return true;
        }
    //+----------------+
        string Get(const uint index)
        {
            for (uint c = 0; c < Values.Size(); c++)
                if (Values[c].k_value == index)
                    return ConvertToString(Values[c].h_value);

            return "-nan";
        }
    //+----------------+
};
//+------------------------------------------------------------------+
#define PrintX(X) Print(#X, " => ", X)
//+------------------------------------------------------------------+
void OnStart(void)
{
    const double H[] = {2.05, 1.97, 1.87, 1.75, 1.99, 2.01, 1.83};
    const uint   K[] = {2, 1, 4, 0, 5, 3, 6};

    st_Data <double> info;

    info.Set(K, H);
    PrintX(info.Get(3));
}
//+------------------------------------------------------------------+